 /****** Object:  StoredProcedure [dbo].[P_TRILHO_PROD_EXCESSO]    Script Date: 01/08/2013 09:04:36 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_TRILHO_PROD_EXCESSO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_TRILHO_PROD_EXCESSO]
GO
 
/****** Object:  StoredProcedure [dbo].[P_TRILHO_PROD_EXCESSO]    Script Date: 24/02/2015 16:18:49 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

--EXECUTE  P_TRILHO_PROD_EXCESSO  1 ,1
CREATE PROCEDURE [dbo].[P_TRILHO_PROD_EXCESSO] (@CD_EMP INT = 1, @CD_CTR_DEPO INT =1) WITH ENCRYPTION AS

DELETE FROM 
	TRILHO_PROD_EXCESSO
WHERE
	CD_CTR_DEPO = @CD_CTR_DEPO
	AND CD_EMP = @CD_EMP;
  
INSERT INTO TRILHO_PROD_EXCESSO
	(DT_MOV,CD_EMP,CD_CTR_DEPO,CD_FILIAL,CD_PROD,
		DS_PROD,DS_ARV_MERC_LINHA,ESEG,EMAX,QTDE_FACEAMENTO,QTDE_FINANCIADO,QTDE_LIMITADOR,
		VLR_EXCESSO,COBERTURA,QT_EST,QTDE_EMAX,EXCESSO,
		QT_EST_ATU,QT_PEND_ENT,QT_PEND_SAI,MEDIAF,VLR_CUSTO,
		VLR_TABELA,CD_SIGLA,CD_FABRIC,CD_ARV_MERC_LINHA,QTDE_MES_VENDA_FECHADO)
SELECT 
	DBO.F_HOJE(),
	C.CD_EMP,
	@CD_CTR_DEPO,
	C.CD_FILIAL,
	C.CD_PROD, 
	PROD.DS_PROD,
	L.DS_ARV_MERC_LINHA,
	C.ESEG,
	C.EMAX,
	C.QTDE_FACEAMENTO,
	C.QTDE_FINANCIADO,
	C.QTDE_LIMITADOR,
	isnull((CONVERT(MONEY, ROUND (C.QT_EST_PEND - ROUND((C.EMAX * C.MEDIAF)/30.0,0),0)) * P.VLR_TABELA),0) VLR_EXCESSO,
	CASE WHEN C.MEDIAF > 0 THEN
		CONVERT(MONEY,(C.QT_EST_PEND/C.MEDIAF) * 30 )
	ELSE
		CONVERT(MONEY,(C.QT_EST_PEND/0.001) * 30 )
	END COBERTURA,
	C.QT_EST_PEND,
	ISNULL(CONVERT(MONEY,ROUND((C.MEDIAF/30.0) * C.EMAX, 0)),0) QTDE_EMAX,
	ISNULL(CONVERT(MONEY, ROUND (C.QT_EST_PEND - ROUND((C.EMAX * C.MEDIAF)/30.0,0),0)),0) EXCESSO,
	C.QT_EST,
	C.QT_PEND_ENT,
	C.QT_PEND_SAI,
	C.MEDIAF,
	C.VLR_CUSTO_MD,
	isnull(P.VLR_TABELA,0),
	C.CD_SIGLA,
	PROD.CD_FABRIC,
	L.CD_ARV_MERC_LINHA,
	isnull(N.QTDE_MES_VENDA_FECHADO,0)
FROM 
	V_EST_PROD_CPL_ESTOQUE C 
	LEFT JOIN EST_PROD_PRECO P ON
	C.CD_EMP	= P.CD_EMP AND
	C.CD_PROD	= P.CD_PROD AND
	C.CD_FILIAL = P.CD_FILIAL
	
	LEFT JOIN EST_PROD_CPL_NASC N ON
	C.CD_EMP	= N.CD_EMP AND
	C.CD_PROD	= N.CD_PROD AND
	C.CD_FILIAL = N.CD_FILIAL
		 
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
	C.CD_EMP	= ARV.CD_EMP AND
	C.CD_PROD	= ARV.CD_PROD
	INNER JOIN EST_ARV_MERC_LINHA L ON
	ARV.CD_EMP				= L.CD_EMP AND
	ARV.CD_ARV_MERC_LINHA	= L.CD_ARV_MERC_LINHA
	
	INNER JOIN EST_PROD PROD ON
	C.CD_EMP	= PROD.CD_EMP AND
	C.CD_PROD	= PROD.CD_PROD
	
	INNER JOIN V_PRC_FILIAL_DEPOSITO D ON
	C.CD_EMP	= D.CD_EMP AND
	C.CD_FILIAL = D.CD_FILIAL  
WHERE
	C.CD_EMP = @CD_EMP
	AND D.CD_CTR_DEPO  = @CD_CTR_DEPO
	AND NOT D.FLAG_DEPO =1
	AND ISNULL(CONVERT(MONEY, ROUND (C.QT_EST_PEND - ROUND((C.EMAX * C.MEDIAF)/30.0,0),0)),0) > 0
	AND ISNULL(PROD.FLAG_ANALISE_EXC_COB,0) = 0;


IF EXISTS 
	(SELECT VALOR 
			FROM PRC_EMP_CONFIG 
					WHERE 
						CD_EMP = @CD_EMP 
						AND CD_CHAVE = 'GERAR_TRILHO_PRECO_TRANSFERENCIA'
						AND VALOR   ='1')
BEGIN
	update  T
	set
		VLR_CUSTO = VLR_TRANSF
	FROM 
		TRILHO_PROD_EXCESSO T 
		JOIN GLB_CONFIG_PRECO_RESSUP_EST_PROD P ON 
		T.CD_EMP  = P.CD_EMP AND
		T.CD_PROD = P.CD_PROD
	WHERE
			T.CD_CTR_DEPO = @CD_CTR_DEPO
		AND T.CD_EMP = @CD_EMP; 

	update  T
	set
		VLR_CUSTO = ISNULL(P.VLR_TRANSF_CALC,0)
	FROM 
		TRILHO_PROD_EXCESSO T 
		JOIN EST_PROD_CPL P ON 
		T.CD_EMP	 = P.CD_EMP AND
		T.CD_FILIAL  = P.CD_FILIAL AND
		T.CD_PROD	 = P.CD_PROD
	WHERE
			T.CD_CTR_DEPO = @CD_CTR_DEPO
		AND T.CD_EMP = @CD_EMP
		AND ISNULL(P.VLR_TRANSF_CALC,0)>0; 
 END
	


GO

 